//
//  Strings.swift
//  Orbis
//
//  Created by KALSI on 6/23/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit

class Constants: NSObject {
    
    //Shadow statics
    static let kRoundBezierPath = "1"
    static let kRectangleBezierPath = "2"
    static let cRedActivated = UIColor.init(red: 174.0/255.0, green: 2.0/255.0, blue: 85.0/255.0, alpha: 1)
    static let cRedDeactivated = UIColor.init(red: 103.0/255.0, green: 66.0/255.0, blue: 122.0/255.0, alpha: 1)
    
    //ARC SIGNALS
    static let sLogin = "PWON"
    static let sLogout = "PWOFF"
    static let sTerminate = "KILL"
    static let sRedAlertAlarm = "EMG"
    static let sRedAlertUserCancel = "EMGUC"
    static let sRedAlerARCtCancel = "EMGAC"
    static let sAmberStart = "AMST"
    static let sAmberExtended = "AMEX"
    static let sAmberStop = "AMSP"
    static let sAmberExpiredAlarm = "AMEXP"
    static let sPositionUpdate = "PUD"
    static let sMapPositionUpdate = "PUDM"
    static let sStatus = "STA"
    static let sFallDetectAlarm = "FDA"
    static let sSilentDialIn = "SDI"
    static let sProfileDownLoaded = "PDL"
    static let sManDown = "MAND"

    
    //Defaults
    static let dUserInfo = "userInfo"
}
